% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program ThurstoneScaling.m
P_iHj = ...
      [0.5181  0.6937  0.8740  0.9665  0.9863  0.9940  0.9983
       0.3256  0.5192  0.7284  0.9113  0.9598  0.9785  0.9927          
       0.1372  0.2813  0.5183  0.7702  0.8745  0.9240  0.9642
       0.0394  0.1050  0.2527  0.5151  0.6690  0.7641  0.8713
       0.0142  0.0480  0.1360  0.3497  0.5009  0.6198  0.7707             
       0.0068  0.0236  0.0881  0.2425  0.3905  0.5076  0.6694
       0.0021  0.0084  0.0379  0.1406  0.2522  0.3577  0.5151];
 
initial_guess = [0.7 1.0 1.5 2.1 2.8 3.5];
oldopts=optimset('fminsearch');
newopts=optimset('Tolx', 1.e-10, 'Tolfun', 1.e-10, 'MaxIter', ...
        100000,  'TolFun', 0.00000000001, 'MaxFunEvals', ...
        100000, 'Diagnostics', 'on');
options = optimset(oldopts, newopts);
Distances = fminsearch('costfunction', initial_guess, ...
        options, P_iHj)

